-- @author SolarEdge 2024 - 2025
Temptation = {};

if getActivatedMods():contains("\\MoodleFramework") == true then
require "MF_ISMoodle";
MF.createMoodle("Temptation");
end

--Temptation = {}
local isMF = getActivatedMods():contains("\\MoodleFramework");

require("ZomboWin/ZomboWin");
--require("ZomboWinDefeatStrip/ZombieHandler");

-- Counters
--local tCount = 0;
hLevel = 0;	-- global var, will be accessed by ZomboWin

-- Threshold
local hSThresh1 = 15;
local hSThresh2 = 30;
local hSThresh3 = 70;
local hSThresh4 = 100;

-- Variable factors, total added hourly
local vfbase = 2;
local vfspunkDefault = 4;
local vfyoungBuck = 5;
local vfAARP = 1;
local vfinPrime = 3;
local vflowEffort = 2;
local vfNymphomaniac = 10;
local vfSexaddict = 10;

-- necro.value is calculated and added to tCount every minute! Hard-capped @ 2.0 per minute
local vfNecrophiliac = 0.5;

local function FemaleCheck() -- Returns true if players' gender is female.
    local player = getPlayer()
    return player:isFemale()
end

local function NoMoodleManager() -- Alternative to update moodle.
	--if isMF then return; end
	local player = getPlayer();
	
	if hLevel ~= nil then
		if hLevel == 0 then
			player:Say("God damn, I needed that!");
			--HaloTextHelper.addText(player, getText("0% chance to defeat a zombie"), HaloTextHelper.getColorRed());
		elseif hLevel == 1 then
			player:Say("*Hysterical* ..tie her up..all the things she won't say no to!!");
			--HaloTextHelper.addText(player, getText("100% chance to defeat a zombie"), HaloTextHelper.getColorRed());
		elseif hLevel == 2 then
			player:Say("*Contemplating*...maybe! ... and why would she say no!?");
			--HaloTextHelper.addText(player, getText("50% chance to defeat a zombie"), HaloTextHelper.getColorRed());
		elseif hLevel == 3 then
			player:Say("*Instrusive thoughts* Why would I do that to a zombie?");
			--HaloTextHelper.addText(player, getText("33% chance to defeat a zombie"), HaloTextHelper.getColorRed());
		elseif hLevel == 4 then
			player:Say("*Pondering* What would she look like beneath those clothes?");
			--HaloTextHelper.addText(player, getText("10% chance to defeat a zombie"), HaloTextHelper.getColorRed());
		end
	end
end

local function MoodleManager() -- Updates the moodle.
	if FemaleCheck() then return; end
	if not isMF then NoMoodleManager() return; end 
	
	local moodle = MF.getMoodle("Temptation");
	if not moodle then --[[print("moodle error: MoodleManager");]] return; end
	
	if hLevel ~= nil then
		if hLevel == 0 then
			moodle:setValue(0.5)
		elseif hLevel == 1 then
			moodle:setValue(0.4)
		elseif hLevel == 2 then
			moodle:setValue(0.3)
		elseif hLevel == 3 then
			moodle:setValue(0.2)
		elseif hLevel == 4 then
			moodle:setValue(0.1)
		end
	end
end

local function tCounter(player) -- Placefinds hLevel based on tCount following hSThresh settings.
	if player:getModData().Temptation.tCount ~= nil then
		if player:getModData().Temptation.tCount < hSThresh1 then
			hLevel = 0;
		elseif player:getModData().Temptation.tCount >= hSThresh1 and player:getModData().Temptation.tCount < hSThresh2 then
			hLevel = 1;
		elseif player:getModData().Temptation.tCount >= hSThresh2 and player:getModData().Temptation.tCount < hSThresh3 then
			hLevel = 2;
		elseif player:getModData().Temptation.tCount >= hSThresh3 and player:getModData().Temptation.tCount < hSThresh4 then
			hLevel = 3;
		elseif player:getModData().Temptation.tCount >= hSThresh4 then
			hLevel = 4;
		end
		
		if player:getModData().Temptation.tCount > 100 then player:getModData().Temptation.tCount = 100; end;
		--print("Current temptation: " .. player:getModData().Temptation.tCount); --debug
		MoodleManager();
	end
end

function tCounterReset(player) -- Resets tCount to 0 and updates hLevel.
	--print("tCounterReset called."); --debug
	if player == nil then local player = getPlayer(); end
	if player:isNPC() then return; end
	local pMod = player:getModData();
	pMod.Temptation = pMod.Temptation or {};
	pMod.Temptation.tCount = pMod.Temptation.tCount or 0;
	pMod.Temptation.tCount = 0; tCounter(player);
end

function tCounterReduce(player, amount)
	if player == nil then local player = getPlayer(); end
	if player:isNPC() then return; end
	local pMod = player:getModData()
	pMod.Temptation = pMod.Temptation or {};
	pMod.Temptation.tCount = pMod.Temptation.tCount or 0;
	pMod.Temptation.tCount = (pMod.Temptation.tCount - amount); 
	
	tCounter(player);
end

function isPanickedCheck()	--should be moved somewhere else...spaghetti coding.
	local player = getPlayer();
	local stats = player:getStats();
	local panic = stats:getPanic();
	
	if panic > 25 then
		--print("isPanickedCheck true");
		return true;
	end
	
	--print("isPanickedCheck false");
	return false;
end

local function temptationCalc(player)
	local increment = 0;
	
	increment = vfbase;
	if player:HasTrait("youngBuck") then increment = increment + vfyoungBuck; end
	if player:HasTrait("AARP") then increment = increment + vfAARP; end
	if player:HasTrait("inPrime") then increment = increment + vfinPrime; end
	if player:HasTrait("spunkDefault") then increment = increment + vfspunkDefault; end
	if player:HasTrait("lowEffort") then increment = increment + vflowEffort; end
	
	if player:HasTrait("Sexaddict") then increment = increment + vfSexaddict; end
	if player:HasTrait("Necrophiliac") then increment = increment + vfNecrophiliac; end
	--print("Temptation increase + " .. increment); --debug
	return increment;
end

local function TemptationIncrease() -- If called, will calculate tCount gained.
	local player = getPlayer();
	if player:isNPC() then return; end
	if not SandboxVars.ZomboWin.enableMod then return; end
	if player:isFemale() then return; end
	player:getModData().Temptation.tCount = player:getModData().Temptation.tCount or 0; 
	if player:getModData().Temptation.tCount ~= nil then if player:getModData().Temptation.tCount >= 100 then return; end end
	if player:HasTrait("itFollows") then return; end
	if FemaleCheck() then --[[print("Female");]] return; end
	
	if isPanickedCheck() then --[[print("TempIncrease: is Panicked! Stop!!");]] return; end
	
	--local temptation = player:getModData().Temptation.tCount;		--disabled, it doesnt work for some reason.
	local increment = temptationCalc(player);
	--Increments tCount hourly based on traits.
	--tCount will affect hLevel when its threshold is reached.

	--print(tickUpdateRate);
	--if temptation == nil then print("tCount error: TemptationIncrease"); return; end
	
	-- here be the main tCount increase code.. do the rest of your calculations here!
	--print("Returned value: " .. increment); --debug
	player:getModData().Temptation.tCount = player:getModData().Temptation.tCount + increment;	--weird. doesn't work with local temptation.
	
	tCounter(player);
end

local function enemyIsValid(player, enemy) -- Return true if enemy is opposite gender of player.
	local isMainHeroFemale = player:isFemale()
	local zombieIsFemale = enemy:isFemale()
	
	if isMainHeroFemale ~= zombieIsFemale then return true; else return false; end
end

local function necroFactor() -- Penalty calc for players with Necrophiliac trait.
	local player = getPlayer();
	if player:isNPC() then return; end
	if not SandboxVars.ZomboWin.enableMod then return; end
	if FemaleCheck() then --[[print("Female");]] return; end
	if player:getModData().Temptation.tCount >= 100 then return; end
	if player:HasTrait("itFollows") then return; end
	
	if isPanickedCheck() then return; end
	
	--if player:getModData().Temptation.tCount == nil then print("tCount error: necroFactor()"); return; end
	if not player:HasTrait("Necrophiliac") then return; end
	local necroAdd = 0;
	
	local enemies = player:getSpottedList()
	local maxDistance = 5 -- future update, factor in traits

	for i = 0, enemies:size() - 1 do
		local enemy = enemies:get(i)
		if enemyIsValid(player, enemy) and enemy:isZombie() and enemy:DistTo(player) <= maxDistance then
			necroAdd = necroAdd + vfNecrophiliac;
		end
	end
	
	--print("Current: " .. player:getModData().Temptation.tCount .. " + necroFactor: " .. necroAdd .. " = " .. player:getModData().Temptation.tCount + necroAdd);
	player:getModData().Temptation.tCount = player:getModData().Temptation.tCount + necroAdd;
	tCounter(player);
end

local function tCountCheck()
	local player = getPlayer();
	player:getModData().Temptation = player:getModData().Temptation or {};
	player:getModData().Temptation.tCount = player:getModData().Temptation.tCount or 0;
end


--Events.OnPlayerUpdate.Add();
Events.EveryOneMinute.Add(necroFactor);
--Events.EveryTenMinutes.Add(TemptationIncrease); --Debug Only
Events.EveryHours.Add(TemptationIncrease); --Normal
--Events.EveryHours.Add(tCounterReset); --Debug Only
Events.OnGameStart.Add(tCountCheck);

return Temptation;

--------- Comments ---------

--[[
if moodle then
	moodle:setValue(0)
	moodle:getValue(0)
end

Method Explained:

tCount increases periodically, the increment is affected by traits and other factors.
tCount has thresholds, when met will increase hLevel, usually by 1 only.
hLevel then updates Moodles or behavior. When the deed is done, hLevel is reset.

Not sure how often should a Temptation increase should occurr yet.

Minimum increase:

24hrs?

]]